<?php
session_start();
// Ensure session variables are set only if the user is logged in
if (!isset($_SESSION['user_id'])) {
header("Location: ../login.php");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.5.0/font/bootstrap-icons.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Audit Master</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
/* Ensure the page fills the full viewport height */
html, body {
    height: 100%; /* Make the document span the full height of the viewport */
    margin: 0;    /* Remove default margins */
    padding: 0;   /* Remove default padding */
}

/* Use Flexbox on the body to handle layout */
body {
    display: flex;
    flex-direction: column; /* Stack content vertically */
    min-height: 100%;       /* Ensure the body height covers the viewport */
}

/* Main content area */
.container {
    flex: 1; /* Allows the content to expand and push the footer down */
    padding-bottom: 20px; /* Prevents footer from overlapping content */
}

/* Footer styles */
footer {
    width: 100%;             /* Full width footer */
    height: 60px;            /* Fixed height */
    background-color: #f8f9fa; /* Light background color */
    text-align: center;      /* Center text horizontally */
    line-height: 60px;       /* Center text vertically */
    margin-top: auto;        /* Push footer to the bottom of the viewport or below content */
}

/* Retain existing styles for other components */
.nav-tabs .nav-link {
    border: 1px solid #ddd;
    color: #6c757d;
    padding: 10px 15px;
}

.nav-tabs .nav-link.active {
    background-color: #f8f9fa;
    color: #000;
    border: 1px solid #ddd;
}

.nav-tabs .nav-link:hover {
    background-color: #e9ecef;
    color: #000;
}

.delimited-section {
    padding: 15px;
    border: 1px solid #ddd;
    border-radius: 5px;
    background-color: #ffffff;
    margin-bottom: 20px;
}

.navbar-text {
    display: none;
}

.nav-item .nav-link.active {
    background-color: #e9ecef; /* Light gray background */
    border-radius: 5px;        /* Rounded corners */
    padding: 8px 15px;         /* Add some padding to create a box effect */
    color: #000;               /* Text color */
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); /* Optional: subtle shadow */
}

@media (min-width: 992px) {
    .navbar-text {
        display: inline;
    }
}

.sticky-top {
    position: -webkit-sticky;
    position: sticky;
    top: 0;
    z-index: 1030;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

.form-check-input {
    width: 1.5em;
    height: 1.5em;
    margin-right: 10px;
}

.form-check-label {
    font-size: 1.2em;
    margin-left: 5px;
}

</style>
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light sticky-top">
        <div class="container">
            <a class="navbar-brand fw-bold" href="#">My ISO Pro</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                <li class="nav-item">
    <a class="nav-link <?php if ($slug === 'dashboard') echo 'active'; ?>" href="dashboard.php"><i class="bi bi-house-door-fill"></i></a>
</li>
<li class="nav-item">
<a class="nav-link" href="dashboard-admin.php">(Admin)</a>
</li>
<li class="nav-item">
<a class="nav-link" href="settings.php">Settings</a>
</li>
<li class="nav-item">
<a class="nav-link" href="terms.php">Terms</a>
</li>
<li class="nav-item">
<a class="nav-link" href="findings.php">Findings</a>
</li>
</ul>
                <!--span class="navbar-text mx-auto fw-bold" style="font-size: 1.5rem;">Audit Master: <?=$title?></span-->
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link <?php if ($slug === 'support') echo 'active'; ?>" href="support.php"><i class="bi bi-question-circle"></i> Help</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php if ($slug === 'profile') echo 'active'; ?>" href="profile.php"><i class="bi bi-person-circle"></i> Profile</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <?php
$hasAlerts = true; // Replace this with your actual condition to determine if there are alerts
?>
<i class="bi <?php echo $hasAlerts ? 'bi-bell-fill' : 'bi-bell'; ?>" style="color:<?php echo $hasAlerts ? 'red' : 'black'; ?>;"></i>
 Alerts
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="alertsDropdown">
                            <li><a class="dropdown-item" href="#">Messages</a></li>
                            <li><a class="dropdown-item" href="#">To-Do Items</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

