<?php
session_start();
include 'config.php'; // Include the centralized database connection

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['username']); // Email serves as the login identifier
    $password = $_POST['password'];

    // Query database for user details
    $sql = "SELECT id, first_name, last_name, company_name, email, password, subscription_status, address, city, state, zip, country 
            FROM myisopro_users WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result(); // Ensure data is stored before fetching
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $first_name, $last_name, $company_name, $email, $hashed_password, $subscription_status, $address, $city, $state, $zip, $country);
        $stmt->fetch();

        // Verify password
        if (password_verify($password, $hashed_password)) {
            // Set session variables
            $_SESSION['user_id'] = $id;
            $_SESSION['first_name'] = $first_name;
            $_SESSION['last_name'] = $last_name;
            $_SESSION['company_name'] = $company_name;
            $_SESSION['email'] = $email;
            $_SESSION['subscription_status'] = $subscription_status;
            $_SESSION['address'] = $address;
            $_SESSION['city'] = $city;
            $_SESSION['state'] = $state;
            $_SESSION['zip'] = $zip;
            $_SESSION['country'] = $country;

            // Retrieve progress_scope from user_progress table
            $progress_sql = "SELECT progress_scope FROM user_progress WHERE user_id = ?";
            $progress_stmt = $conn->prepare($progress_sql);
            $progress_stmt->bind_param("i", $id);
            $progress_stmt->execute();
            $progress_stmt->store_result();

            if ($progress_stmt->num_rows > 0) {
                $progress_stmt->bind_result($progress_scope);
                $progress_stmt->fetch();
                $_SESSION['progress_scope'] = $progress_scope; // Store in session
            } else {
                $_SESSION['progress_scope'] = 0; // Default value if no progress found
            }

            $progress_stmt->close();

            // Redirect to the protected dashboard
            header("Location: ../members/dashboard.php");
            exit();
        } else {
            // Incorrect password
            $_SESSION['message'] = 'invalidpassword';
            header("Location: ../login.php");
            exit();
        }
    } else {
        // No user found with that email
        $_SESSION['message'] = 'nouser';
        header("Location: ../login.php");
        exit();
    }

    $stmt->close();
    $conn->close();
}
?>
