<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Add Auditors - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    .content-wrapper {
      padding: 20px;
    }
    .audit-buttons {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.01);
    }
    /* Add a border to the top of the card-header */
    .card-header {
      border-top: 4px solid #1e88e5;
    }
    /* Active state for the footer section */
    footer .footer-section.active {
      border-top: 4px solid #ffffff; /* White border to indicate active state */
      box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1); /* Subtle shadow for emphasis */
    }
  </style>
</head>
<body>

  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          <a class="btn btn-outline-secondary me-2" href="alerts.php">
            <i class="fa-solid fa-bell"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Audit Table Card with Updated Header -->
  <div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
      <div>
        <h5 class="mb-0">Auditors</h5>
        <small class="text-muted">Manage and add auditors</small>
      </div>
      <!-- Updated Button to "Add Auditor" -->
      <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#addAuditorModal">
        <i class="fa-solid fa-plus me-1"></i> Add Auditor
      </button>
    </div>
    <ul class="list-group list-group-flush audit-table">
      <li class="list-group-item d-flex flex-wrap justify-content-between align-items-start">
        <div>
          <strong>John Doe</strong> - <span style="color: green;">Lead Auditor</span>
          <div style="font-size: 12px; color: gray;">
            Email: johndoe@example.com | Phone: (123) 456-7890 | Certified: Yes
          </div>
          <div style="font-size: 12px; color: gray;">
            Experience: 5 Years | Specialization: ISO 9001
          </div>
        </div>
        <div class="audit-buttons">
          <a href="audit-planning.php?id=1" class="btn btn-outline-success">Edit Auditor</a>
          <a href="#" class="btn btn-secondary">Remove Auditor</a>
        </div>
      </li>
      <li class="list-group-item d-flex flex-wrap justify-content-between align-items-start">
        <div>
          <strong>Jane Smith</strong> - <span style="color: blue;">Auditor</span>
          <div style="font-size: 12px; color: gray;">
            Email: janesmith@example.com | Phone: (987) 654-3210 | Certified: Yes
          </div>
          <div style="font-size: 12px; color: gray;">
            Experience: 3 Years | Specialization: ISO 14001
          </div>
        </div>
        <div class="audit-buttons">
          <a href="#" class="btn btn-outline-success">Edit Auditor</a>
          <a href="#" class="btn btn-secondary">Remove Auditor</a>
        </div>
      </li>
    </ul>
  </div>

  <!-- Fullscreen Modal for Adding an Auditor -->
  <div class="modal fade" id="addAuditorModal" tabindex="-1" aria-labelledby="addAuditorModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addAuditorModalLabel">Add New Auditor</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <!-- Form for Adding an Auditor -->
          <form>
            <div class="mb-3">
              <label for="auditorName" class="form-label">Auditor Name</label>
              <input type="text" class="form-control" id="auditorName" placeholder="Enter auditor's name">
            </div>
            <div class="mb-3">
              <label for="auditorEmail" class="form-label">Email</label>
              <input type="email" class="form-control" id="auditorEmail" placeholder="Enter auditor's email">
            </div>
            <div class="mb-3">
              <label for="auditorPhone" class="form-label">Phone</label>
              <input type="tel" class="form-control" id="auditorPhone" placeholder="Enter auditor's phone number">
            </div>
            <div class="mb-3">
              <label for="auditorRole" class="form-label">Role</label>
              <select class="form-select" id="auditorRole">
                <option value="Lead Auditor">Lead Auditor</option>
                <option value="Auditor">Auditor</option>
              </select>
            </div>
            <div class="mb-3">
              <label for="auditorCertification" class="form-label">Certification</label>
              <select class="form-select" id="auditorCertification">
                <option value="Yes">Yes</option>
                <option value="No">No</option>
              </select>
            </div>
            <div class="mb-3">
              <label for="auditorExperience" class="form-label">Experience (Years)</label>
              <input type="number" class="form-control" id="auditorExperience" placeholder="Enter years of experience">
            </div>
            <div class="mb-3">
              <label for="auditorSpecialization" class="form-label">Specialization</label>
              <input type="text" class="form-control" id="auditorSpecialization" placeholder="Enter specialization">
            </div>
            <!-- Auditor Competencies Section -->
            <div class="mb-3">
              <label for="auditorCompetencies" class="form-label">Competencies</label>
              <div class="form-text">Select or enter the auditor's competencies (e.g., ISO standards).</div>
              <select class="form-select" id="auditorCompetencies" multiple>
                <option value="ISO 9001">ISO 9001</option>
                <option value="ISO 14001">ISO 14001</option>
                <option value="ISO 45001">ISO 45001</option>
                <option value="ISO 27001">ISO 27001</option>
                <option value="ISO 22000">ISO 22000</option>
              </select>
              <small class="form-text text-muted">Hold Ctrl (Windows) or Command (Mac) to select multiple options.</small>
            </div>
          </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary">Save Auditor</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer class="fixed-bottom border-top">
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center active">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors</div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Help</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>