<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Audit Master - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    .content-wrapper {
      padding: 20px;
    }
    .audit-buttons {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.01);
    }
  </style>
</head>
<body>

  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          
          <a class="btn btn-outline-secondary me-2" href="alerts.php">
            <i class="fa-solid fa-bell"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Audit Table Card with Updated Header -->
  <div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
      <div>
        <h5 class="mb-0">Active Audits</h5>
        <small class="text-muted">Overview of your current audits</small>
      </div>
      <a href="new-audit-type.php" class="btn btn-sm btn-outline-secondary">
        <i class="fa-solid fa-plus me-1"></i> New Audit
      </a>
    </div>
    <ul class="list-group list-group-flush audit-table">
      <li class="list-group-item d-flex flex-wrap justify-content-between align-items-start">
        <div>
          <strong>Jax Code Academy, Inc.</strong> - <span style="color: green;">65% Score</span>
          <div style="font-size: 12px; color: gray;">
            Type: Internal Audit | Standard: ISO 9001 | Created: 2025-02-19
          </div>
          <div style="font-size: 12px; color: gray;">
            Site Type: Single | Assigned Auditor: John Doe | Audit Scope: Full Compliance
          </div>
        </div>
        <div class="audit-buttons">
          <a href="audit-report-summary.php?id=1" class="btn btn-outline-success">Audit Report Summary</a>
          <a href="#" class="btn btn-secondary">Grant Access</a>
        </div>
      </li>
      <li class="list-group-item d-flex flex-wrap justify-content-between align-items-start">
        <div>
          <strong>XYZ Corporation</strong> - <span style="color: red;">42% Score</span>
          <div style="font-size: 12px; color: gray;">
            Type: Supplier Audit | Standard: ISO 14001 | Created: 2025-01-15
          </div>
          <div style="font-size: 12px; color: gray;">
            Site Type: Multi-Site | Assigned Auditor: Jane Smith | Audit Scope: Environmental Standards
          </div>
        </div>
        <div class="audit-buttons">
          <a href="audit-report-summary.php?id=2" class="btn btn-outline-success">Audit Report Summary</a>
          <a href="#" class="btn btn-secondary">Grant Access</a>
        </div>
      </li>
    </ul>
  </div>

  <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer class="fixed-bottom border-top">
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors </div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Help</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
