<?php 

$title = "Audit Planning";
$slug = "dashboard";

include 'inc.header.php'; ?>

<!-- Dashboard Content -->

    <!-- Tabs Section -->
    <div class="container mt-3">
        <ul class="nav nav-tabs" id="myTab" role="tablist" style="overflow-x: auto; white-space: nowrap; flex-wrap: nowrap;">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="true">Profile</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="plan-scope-tab" data-bs-toggle="tab" data-bs-target="#plan-scope" type="button" role="tab" aria-controls="plan-scope" aria-selected="false">Plan/Scope</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="notes-evidence-tab" data-bs-toggle="tab" data-bs-target="#notes-evidence" type="button" role="tab" aria-controls="notes-evidence" aria-selected="false">Notes/Evidence</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="report-formatting-tab" data-bs-toggle="tab" data-bs-target="#report-formatting" type="button" role="tab" aria-controls="report-formatting" aria-selected="false">Report Formatting</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="findings-tab" data-bs-toggle="tab" data-bs-target="#findings" type="button" role="tab" aria-controls="findings" aria-selected="false">Findings</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="corrective-action-tab" data-bs-toggle="tab" data-bs-target="#corrective-action" type="button" role="tab" aria-controls="corrective-action" aria-selected="false">Corrective Action</button>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active mb-5" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                <h2 class="text-center mt-4">Profile Info</h2>
                <form method="post" action="profile_process.php">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="companyName" class="form-label"><strong>Company Name</strong></label>
                                <input type="text" class="form-control" id="companyName" name="company_name" value="<?php echo isset($_SESSION['companyName']) ? htmlspecialchars($_SESSION['companyName'], ENT_QUOTES) : ''; ?>">
                            </div>
                            <div class="mb-3">
                                <label for="auditorId" class="form-label"><strong>Auditor ID</strong></label>
                                <input type="text" class="form-control" id="auditorId" name="auditor_id">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="address" class="form-label"><strong>Address</strong></label>
                                <input type="text" class="form-control" id="address" name="address">
                            </div>
                            <div class="mb-3">
                                <label for="cityStateZip" class="form-label"><strong>City, State, ZIP</strong></label>
                                <div class="d-flex">
                                    <input type="text" class="form-control me-2" id="city" name="city" placeholder="City">
                                    <input type="text" class="form-control me-2" id="state" name="state" placeholder="State">
                                    <input type="text" class="form-control" id="zip" name="zip" placeholder="ZIP">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Site Type</strong></label><br>
                                <div class="form-check">
    <input class="form-check-input" type="radio" id="singleSite" name="site_type" value="single">
    <label class="form-check-label" for="singleSite" style="font-size: 1.2em;">Single Site</label>
</div>
<div class="form-check">
    <input class="form-check-input" type="radio" id="multipleSites" name="site_type" value="multiple">
    <label class="form-check-label" for="multipleSites" style="font-size: 1.2em;">Multiple Sites</label>
</div>

                            </div>
                        </div>
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Audit Type</strong></label><br>
                                <div class="form-check">
    <input class="form-check-input" type="radio" id="internalAudit" name="audit_type" value="internal">
    <label class="form-check-label" for="internalAudit" style="font-size: 1.2em;">Internal</label>
</div>
<div class="form-check">
    <input class="form-check-input" type="radio" id="supplyChainAudit" name="audit_type" value="supplyChain">
    <label class="form-check-label" for="supplyChainAudit" style="font-size: 1.2em;">Supply Chain</label>
</div>

                            </div>
                        </div>
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Standards</strong></label><br>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso9001" name="standards[]" value="ISO9001 Quality">
                                    <label class="form-check-label" for="iso9001" style="font-size: 1.2em;">ISO9001 Quality</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso27001" name="standards[]" value="ISO27001 Quality">
                                    <label class="form-check-label" for="iso27001" style="font-size: 1.2em;">ISO 27001 International</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso45001" name="standards[]" value="ISO 45001 Safety">
                                    <label class="form-check-label" for="iso45001" style="font-size: 1.2em;">ISO 45001 Safety</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso14001" name="standards[]" value="ISO14001 Environmental">
                                    <label class="form-check-label" for="iso14001" style="font-size: 1.2em;">ISO14001 Environmental</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="customStandard" name="standards[]" value="Custom">
                                    <label class="form-check-label" for="customStandard" style="font-size: 1.2em;">Custom</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-light w-100 mt-3">Submit</button>
                </form>
            </div>
            <div class="tab-pane fade" id="plan-scope" role="tabpanel" aria-labelledby="plan-scope-tab">
                <h2 class="text-center mt-4">Plan/Scope Section</h2>
                <p>Content for Plan/Scope goes here...</p>
            </div>
            <div class="tab-pane fade" id="notes-evidence" role="tabpanel" aria-labelledby="notes-evidence-tab">
                <h2 class="text-center mt-4">Notes/Evidence Section</h2>
                <p>Content for Notes/Evidence goes here...</p>
            </div>
            <div class="tab-pane fade" id="report-formatting" role="tabpanel" aria-labelledby="report-formatting-tab">
                <h2 class="text-center mt-4">Report Formatting Section</h2>
                <p>Content for Report Formatting goes here...</p>
            </div>
            <div class="tab-pane fade" id="findings" role="tabpanel" aria-labelledby="findings-tab">
                <h2 class="text-center mt-4">Findings Section</h2>
                <style>
        .audit-section {
            margin: 20px 0;
        }

        .audit-section h2 {
            font-size: 20px;
            color: #333;
            margin-bottom: 10px;
        }

        .audit-section table {
            width: 100%;
            border-collapse: collapse;
        }

        .audit-section table, th, td {
            border: 1px solid #ddd;
        }

        th, td {
            padding: 15px;
            text-align: left;
        }

        th {
            background-color: #f8f8f8;
        }

        .status-yes {
            background-color: #a7d38c;
        }

        .status-no {
            background-color: #ff7373;
        }

        .status-flagged {
            background-color: #f4f4f9;
        }
    </style>


    <div class="container">
        <h1>ISO 9001 Audit Report</h1>
        <div class="audit-section">
            <h2>Context of the Organization</h2>
            <table>
                <tr>
                    <th>Question</th>
                    <th>Status</th>
                </tr>
                <tr>
                    <td>Have all external and internal issues that are relevant to your organization's purpose and the achievement of customer satisfaction and the organization's strategic direction been determined?</td>
                    <td class="status-yes">Yes</td>
                </tr>
                <tr>
                    <td>Are these issues reviewed and monitored on a regular basis?</td>
                    <td class="status-yes">Yes</td>
                </tr>
                <tr>
                    <td>Have the needs and expectations of interested parties that are relevant to the QMS been determined?</td>
                    <td class="status-yes">Yes</td>
                </tr>
                <!-- Add the rest of the context of the organization section here -->
            </table>
        </div>

        <div class="audit-section">
            <h2>Leadership</h2>
            <table>
                <tr>
                    <th>Question</th>
                    <th>Status</th>
                </tr>
                <tr>
                    <td>Has top management taken accountability for the effectiveness of the QMS?</td>
                    <td class="status-yes">Yes</td>
                </tr>
                <tr>
                    <td>Have the policy and objectives for the QMS, which are compatible with the strategic direction of the organization, been established and communicated?</td>
                    <td class="status-no">No</td>
                </tr>
                <tr>
                    <td>Have the objectives been established at relevant departmental and individual levels with the business?</td>
                    <td class="status-no">No</td>
                </tr>
                <!-- Add the rest of the leadership section here -->
            </table>
        </div>

        <!-- Add more sections as necessary -->
    </div>
            </div>
            <div class="tab-pane fade" id="corrective-action" role="tabpanel" aria-labelledby="corrective-action-tab">
                <h2 class="text-center mt-4">Corrective Action Section</h2>
                <p>Content for Corrective Action goes here...</p>
            </div>
        </div>
    </div>

<?php include 'inc.footer.php';
