<?php 

$title = "ISO 9001 Create Your Audit Checklist";
$slug = "template";

include 'inc.header.php'; ?>

<div class="container">
    <div class="row">
        <div class="col-md-12">
            <h1 class="text-center mt-5"><?php echo $_SESSION['companyName']; ?></h1>

            <h2 class="mb-4">ISO 9001 Create Your Audit Checklist</h2>
            <p>Check questions you want to use or create new questions:</p>
            <form action="#" method="post" id="auditForm">
                <div id="checklistContainer"></div>
                <button type="submit" class="btn btn-light mt-4 w-100" style="border:1px solid gray;">Next</button>
            </form>
        </div>
    </div>
</div>

<?php include 'inc.footer.php'; ?>

<style>
    .clause-section {
        padding: 20px;
        margin-top: 20px;
        border-radius: 5px;
    }
    .clause-4 { background-color: #e3f2fd; border-left: 6px solid #2196f3; }
    .clause-5 { background-color: #f3e5f5; border-left: 6px solid #9c27b0; }
    .clause-6 { background-color: #fce4ec; border-left: 6px solid #e91e63; }
    .clause-7 { background-color: #e8f5e9; border-left: 6px solid #4caf50; }
    .clause-8 { background-color: #fff3e0; border-left: 6px solid #ff9800; }
    .clause-9 { background-color: #ede7f6; border-left: 6px solid #673ab7; }
    .clause-10 { background-color: #ffebee; border-left: 6px solid #f44336; }
    .add-question-btn {
        margin-top: 10px;
    }
    .custom-question {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-top: 10px;
    }
</style>

<script>
    const checklistData = {
        "4": { title: "Context of the Organization", blurb: "Understanding internal and external factors affecting quality management.", questions: [
            { clause: "4.1", question: "Has the organization determined internal and external issues affecting its QMS?" },
            { clause: "4.2", question: "Are the needs and expectations of interested parties identified?" },
            { clause: "4.3", question: "Is the scope of the QMS documented and maintained?" },
            { clause: "4.4", question: "Are QMS processes defined, documented, and implemented?" }
        ]},
        "5": { title: "Leadership", blurb: "Top management commitment to the QMS.", questions: [
            { clause: "5.1", question: "Does top management demonstrate leadership and commitment to the QMS?" },
            { clause: "5.2", question: "Is a quality policy established, communicated, and understood?" },
            { clause: "5.3", question: "Are responsibilities and authorities for the QMS assigned and communicated?" }
        ]},
        "6": { title: "Planning", blurb: "Identifying and addressing risks and opportunities.", questions: [
            { clause: "6.1", question: "Are risks and opportunities identified and addressed?" },
            { clause: "6.2", question: "Are quality objectives established and measurable?" },
            { clause: "6.3", question: "Is there a process for planning changes to the QMS?" }
        ]},
        "7": { title: "Support", blurb: "Providing adequate resources for the QMS.", questions: [
            { clause: "7.1", question: "Are adequate resources provided for the QMS?" },
            { clause: "7.2", question: "Are employees competent and trained for their roles?" },
            { clause: "7.3", question: "Is documented information properly controlled (created, updated, stored)?" }
        ]},
        "8": { title: "Operation", blurb: "Ensuring operational control to meet requirements.", questions: [
            { clause: "8.1", question: "Are operational controls in place to meet customer and regulatory requirements?" },
            { clause: "8.2", question: "Are customer communication and contract review processes effective?" },
            { clause: "8.3", question: "Are external providers and suppliers evaluated for compliance?" },
            { clause: "8.4", question: "Are controls in place to prevent nonconforming product or service delivery?" }
        ]},
        "9": { title: "Performance Evaluation", blurb: "Monitoring and measuring QMS effectiveness.", questions: [
            { clause: "9.1", question: "Is there a process for monitoring and measuring QMS effectiveness?" },
            { clause: "9.2", question: "Are customer satisfaction levels monitored?" },
            { clause: "9.3", question: "Are internal audits conducted at planned intervals?" }
        ]},
        "10": { title: "Improvement", blurb: "Identifying nonconformities and taking corrective action.", questions: [
            { clause: "10.1", question: "Are nonconformities identified and corrective actions taken?" },
            { clause: "10.2", question: "Is there a process for continual improvement of the QMS?" }
        ]}
    };

    function renderChecklist() {
        const checklistContainer = document.getElementById("checklistContainer");
        checklistContainer.innerHTML = "";

        Object.keys(checklistData).forEach(clauseNumber => {
            const section = checklistData[clauseNumber];
            const sectionDiv = document.createElement("div");
            sectionDiv.classList.add("clause-section", `clause-${clauseNumber}`);
            sectionDiv.innerHTML = `<h4>Clause ${clauseNumber}: ${section.title}</h4><p>${section.blurb}</p>`;

            section.questions.forEach(item => {
                const div = document.createElement("div");
                div.classList.add("form-check");
                div.innerHTML = `<input class="form-check-input" type="checkbox" name="questions[]" value="${item.question}" checked>
                    <label class="form-check-label">(${item.clause}) ${item.question}</label>`;
                sectionDiv.appendChild(div);
            });

            const addQuestionBtn = document.createElement("button");
            addQuestionBtn.classList.add("btn", "btn-sm", "btn-link", "add-question-btn");
            addQuestionBtn.innerText = "Add Custom Question";
            addQuestionBtn.addEventListener("click", (e) => {
                e.preventDefault();
                addCustomQuestion(sectionDiv, clauseNumber);
            });
            sectionDiv.appendChild(addQuestionBtn);

            checklistContainer.appendChild(sectionDiv);
        });
    }

    function addCustomQuestion(sectionDiv, clauseNumber) {
        const inputDiv = document.createElement("div");
        inputDiv.classList.add("custom-question");

        const input = document.createElement("input");
        input.type = "text";
        input.classList.add("form-control");
        input.placeholder = `Enter custom question for Clause ${clauseNumber}`;

        const removeButton = document.createElement("button");
        removeButton.classList.add("btn", "btn-danger", "btn-sm");
        removeButton.innerText = "x";
        removeButton.addEventListener("click", () => inputDiv.remove());

        inputDiv.appendChild(input);
        inputDiv.appendChild(removeButton);
        sectionDiv.appendChild(inputDiv);
    }

    renderChecklist();
</script>
