<?php 

$title = "ISO Guidelines";
$slug="isoguidelines";

include 'inc.header.php'; ?>

<div class="container"><div class="row"><div class="col-md-12">


<h1 class="text-center mt-5"><?php echo $_SESSION['companyName']; ?></h1>

<header class="bg-light text-dark text-center py-5">
        <h1>ISO 9001:2015 Quality Management System</h1>
        <p>Ensuring Quality, Customer Satisfaction, and Continuous Improvement</p>
    </header>

    <div class="container my-5">
        <section id="overview" class="mb-5">
            <h2 class="text-primary">Overview</h2>
            <p>ISO 9001:2015 is an international standard for quality management systems (QMS), providing organizations with a framework to enhance efficiency, customer satisfaction, and continuous improvement.</p>
        </section>

        <section id="principles" class="mb-5">
            <h2 class="text-primary">Seven Quality Management Principles</h2>
            <div class="row">
                <div class="col-md-6">
                    <ul class="list-group">
                        <li class="list-group-item"><strong>1. Customer Focus</strong> – Meeting customer expectations and satisfaction.</li>
                        <li class="list-group-item"><strong>2. Leadership</strong> – Creating a unified purpose and direction.</li>
                        <li class="list-group-item"><strong>3. Engagement of People</strong> – Empowering and involving employees.</li>
                        <li class="list-group-item"><strong>4. Process Approach</strong> – Managing activities as interconnected processes.</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul class="list-group">
                        <li class="list-group-item"><strong>5. Improvement</strong> – Continuous improvement as a core objective.</li>
                        <li class="list-group-item"><strong>6. Evidence-Based Decision Making</strong> – Using data-driven insights.</li>
                        <li class="list-group-item"><strong>7. Relationship Management</strong> – Managing relationships with suppliers and stakeholders.</li>
                    </ul>
                </div>
            </div>
        </section>

        <section id="requirements" class="mb-5">
            <h2 class="text-primary">ISO 9001:2015 Requirements</h2>
            <p>Organizations seeking ISO 9001 certification must follow these core requirements:</p>
            <ol class="list-group list-group-numbered">
                <li class="list-group-item"><strong>Context of the Organization:</strong> Understanding external and internal issues that impact quality.</li>
                <li class="list-group-item"><strong>Leadership:</strong> Commitment from top management to drive quality improvements.</li>
                <li class="list-group-item"><strong>Planning:</strong> Identifying risks and opportunities for improvement.</li>
                <li class="list-group-item"><strong>Support:</strong> Providing resources, training, and a proper working environment.</li>
                <li class="list-group-item"><strong>Operations:</strong> Implementing quality-driven processes and customer-focused strategies.</li>
                <li class="list-group-item"><strong>Performance Evaluation:</strong> Monitoring, measuring, and analyzing key performance metrics.</li>
                <li class="list-group-item"><strong>Continuous Improvement:</strong> Identifying areas for growth and implementing changes.</li>
            </ol>
        </section>

        <section id="certification" class="mb-5">
            <h2 class="text-primary">How to Get Certified</h2>
            <p>Organizations can achieve ISO 9001 certification through these steps:</p>
            <div class="row">
                <div class="col-md-4">
                    <div class="card text-white bg-secondary mb-3">
                        <div class="card-body">
                            <h5 class="card-title">1. Prepare</h5>
                            <p class="card-text">Assess current processes, train employees, and align with ISO 9001 standards.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-white bg-secondary mb-3">
                        <div class="card-body">
                            <h5 class="card-title">2. Implement</h5>
                            <p class="card-text">Document and integrate quality management processes across the organization.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-white bg-secondary mb-3">
                        <div class="card-body">
                            <h5 class="card-title">3. Audit & Certify</h5>
                            <p class="card-text">Undergo an external audit by a certification body to receive ISO 9001 accreditation.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

</div></div></div>

<?php include 'inc.footer.php';
