<?php 

$title = "Settings";
$slug="settings";

include 'inc.header.php'; ?>

<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'config.php';
?>


<div class="container"><div class="row"><div class="col-md-12">


<h1 class="text-center mt-5"><?=$title?></h1>

<?php

include 'config.php'; // Database connection

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php"); // Redirect to login page if not logged in
    exit();
}

$user_id = $_SESSION['user_id'];
$message = "";

// Fetch user data
$stmt = $conn->prepare("SELECT first_name, last_name, email, company_name, phone FROM myisopro_users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $email = trim($_POST['email']);
    $company_name = trim($_POST['company_name']);
    $phone = trim($_POST['phone']);

    $update_stmt = $conn->prepare("UPDATE myisopro_users SET first_name=?, last_name=?, email=?, company_name=?, phone=? WHERE id=?");
    $update_stmt->bind_param("sssssi", $first_name, $last_name, $email, $company_name, $phone, $user_id);

    if ($update_stmt->execute()) {
        // Update session variables to reflect changes
        $_SESSION['first_name'] = $first_name;
        $_SESSION['last_name'] = $last_name;
        $_SESSION['email'] = $email;
        $_SESSION['company_name'] = $company_name;

        // Fetch subscription status again
        $sub_stmt = $conn->prepare("SELECT subscription_status FROM myisopro_users WHERE id = ?");
        $sub_stmt->bind_param("i", $user_id);
        $sub_stmt->execute();
        $sub_result = $sub_stmt->get_result();
        $sub_row = $sub_result->fetch_assoc();

        if ($sub_row) {
            $_SESSION['subscription_status'] = $sub_row['subscription_status'];
        }

        $message = "<div class='alert alert-success'>Settings updated successfully.</div>";

        // Refresh user data array for form values
        $user = ['first_name' => $first_name, 'last_name' => $last_name, 'email' => $email, 'company_name' => $company_name, 'phone' => $phone];
    } else {
        $message = "<div class='alert alert-danger'>Failed to update settings. Please try again.</div>";
    }
}

?>
    <div class="container mt-5">
        <h2>Edit Settings</h2>
<br>
note: add program metrics and a lot 
more settings for report displays, customize reports,  <br><br>
        <?php echo $message; ?>
        <form method="POST">
            <div class="mb-3">
                <label for="first_name" class="form-label">First Name</label>
                <input type="text" class="form-control" id="first_name" name="first_name" value="<?= htmlspecialchars($user['first_name']) ?>" required>
            </div>
            <div class="mb-3">
                <label for="last_name" class="form-label">Last Name</label>
                <input type="text" class="form-control" id="last_name" name="last_name" value="<?= htmlspecialchars($user['last_name']) ?>" required>
            </div>
            <div class="mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="email" class="form-control" id="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required>
            </div>
            <div class="mb-3">
                <label for="company_name" class="form-label">Company Name</label>
                <input type="text" class="form-control" id="company_name" name="company_name" value="<?= htmlspecialchars($user['company_name']) ?>" required>
            </div>
            <div class="mb-3">
                <label for="phone" class="form-label">Phone</label>
                <input type="text" class="form-control" id="phone" name="phone" value="<?= htmlspecialchars($user['phone']) ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Save Changes</button>
            <a href="dashboard.php" class="btn btn-secondary">Cancel</a>
        </form>
    </div>



</></div></div>

<?php include 'inc.footer.php';
